/*==============================================================================
This .do files brings in Labor market variables from censuses available on
IPUMS International for the following countries and years: 

Austria: 	1971, 1981, 1991, 2001
France: 	1962, 1968, 1975, 1982, 1990, 1999, 2006
Spain		1981, 1991, 2001
Switzerland	1970, 1980, 1990, 2000

*=============================================================================*/

clear
set more off 

cd "$scratch/IPUMS International Data"

! uncompress ipumsi_00016.dat.Z

do ipumsi_00016.do

keep if cntry==40|cntry==250|cntry==756|cntry==724

gen country=""
replace country="AT" if cntry==40
replace country="CH" if cntry==756
replace country="ES" if cntry==724
replace country="FR" if cntry==250

tostring enuts3, replace  force
gen nuts3 = country + substr(enuts3,2,4) if country=="AT"|country=="ES"
	replace nuts3="AT111&AT113" if nuts3=="AT111"
replace nuts3 = country + substr(enuts3,3,5) if country=="CH"

gen nuts2 = substr(nuts3,1,4) if nuts3!=""
tostring enuts2, replace force
	replace nuts2 = country + substr(enuts2,3,4)  if country=="FR"

*a) Define Labor variables
* Note: Restricted to non-group quarters, 15+ 
gen POP_IPUMS		= 1
gen EMP_IPUMS	 	= 1 if  eempsta==110 				& age>=15 
gen UNEMP_IPUMS 	= 1 if (eempsta==120|eempsta==121)  & age>=15

local countries "AT CH ES FR"

replace wtper = round(wtper)

keep nuts* country year POP EMP UNEMP wtper

tempfile all_countries_precollapse
save `all_countries_precollapse.dta'

foreach country of local countries { 
	
	display "`country'"
	use POP EMP UNEMP nuts3 country year wtper if country=="`country'" /// 
			& nuts3!="" using `all_countries_precollapse.dta', clear

	drop if nuts3=="" 

	capture collapse (sum) POP EMP UNEMP (first) country [fw=wtper], ///
			by(nuts3 year) fast

	capture rename nuts3 nuts

	capture tempfile `country'_nuts3
	capture save 	``country'_nuts3.dta'

	use POP EMP UNEMP nuts2 country year wtper if country=="`country'" /// 
			& nuts2!="" using `all_countries_precollapse.dta', clear
			
	capture collapse (sum) POP EMP UNEMP (first) country [fw=wtper], ///
			by(nuts2 year) fast

	capture rename nuts2 nuts

	capture tempfile `country'_nuts2
	capture save 	``country'_nuts2.dta'

	gen nuts1 = substr(nuts,1,3)
	
	collapse (sum) POP EMP UNEMP (first) country, by(nuts1 year) fast

	rename nuts1 nuts

	tempfile `country'_nuts1
	save 	``country'_nuts1.dta'
	
	collapse (sum) POP EMP UNEMP, by(country year) fast

	gen nuts = country 

	append using ``country'_nuts1.dta'
	append using ``country'_nuts2.dta'
	append using ``country'_nuts3.dta'

	tempfile `country'_census
	save ``country'_census.dta'
}

use `AT_census.dta', clear
	append using `CH_census.dta'
	append using `ES_census.dta'
	append using `FR_census.dta'
duplicates drop

********************************************************************************

*Composite NUTS in IPUMS: 
replace nuts = "CH053&CH054" if nuts=="CH053"

gen LF_IPUMS			= EMP_IPUMS + UNEMP_IPUMS

foreach var of varlist POP LF EMP UNEMP {
	replace `var' = `var'/1000
}

drop if nuts=="ES9"| nuts=="ES99"|nuts=="ES999"
drop if nuts=="FR82" & year==1982 //something not right about this observation

keep year country nuts POP LF EMP UNEMP
order year country nuts POP LF EMP UNEMP

save "$dta_files/IPUMS_labor.dta", replace

! compress ipumsi_00016.dat
